import { prisma } from '@/lib/prisma';
import { notFound } from 'next/navigation';
import PublicMenu from '@/components/public-menu';

interface PageProps {
  params: {
    slug: string;
  };
}

export default async function PublicMenuPage({ params }: PageProps) {
  const restaurant = await prisma.restaurant.findUnique({
    where: {
      slug: params.slug,
      status: 'active',
    },
    include: {
      categories: {
        orderBy: { sortOrder: 'asc' },
        include: {
          products: {
            where: { isVisible: true },
            orderBy: { sortOrder: 'asc' },
          },
        },
      },
    },
  });

  if (!restaurant) {
    notFound();
  }

  return <PublicMenu restaurant={restaurant} />;
}